# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdvaluevector import *
from .sdapiobject import *
from .sdbasetypes import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueColorRGBA(SDValueVector):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueColorRGBA
        """
        super(SDValueColorRGBA, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(value : ColorRGBA) -> SDValueColorRGBA:
        """
        Create new SDValueColorRGBA

        :param value: The color value
        """
        outSDValueColorRGBA = ctypes.c_void_p()
        _res = sd.getContext().SDValueColorRGBA_sNew(ctypes.byref(value), ctypes.byref(outSDValueColorRGBA))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueColorRGBA, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueColorRGBA.value, ownHandle=True)

    def get(self) -> ColorRGBA:
        """
        Get the base type value as ColorRGBA

        """
        outValue = ColorRGBA()
        _res = self.mAPIContext.SDValueColorRGBA_get(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

